/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.requests;

import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestErrorIds;
import com.ibm.hwmca.base.rsf.util.RsfHexadecimal;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.ProblemReportRequestBody;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import java.io.UnsupportedEncodingException;

public class SdPapRequestContent
implements BaseRsfRequestErrorIds {
    private static final String TRACE_MASKT = "XRSF   T";
    private static final String TRACE_MASKF = "XRSF   F";
    private static final String TRACE_MASKD = "XRSF   D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(94, "RsfRequest");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    ProblemReportRequestBody data;
    String customerContact;
    String customerNumber;
    String baseCustomerNumber;
    String cpn;
    String nsfiData;
    private static String EBCDIC = "Cp500";
    private static String COPYWRIT = "CCOOPPRR..  IIBBMM  11998844                            ";
    private static int neg = -256;

    public SdPapRequestContent(ProblemReportRequestBody data) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "->SdPapRequestContent::constructor");
        this.data = data;
        this.customerContact = data.getAttribute("Problem Customer contact");
        if (this.customerContact == null) {
            throw new IllegalArgumentException("Missing 'Problem Customer contact' attribute from data");
        }
        this.customerNumber = data.getAttribute("Customer number");
        if (this.customerNumber == null) {
            throw new IllegalArgumentException("Missing 'Customer number' attribute from data");
        }
        this.baseCustomerNumber = data.getAttribute("Base customer number");
        if (this.baseCustomerNumber == null) {
            throw new IllegalArgumentException("Missing 'Base customer number' attribute from data");
        }
        this.cpn = data.getAttribute("Problem Number");
        if (this.cpn == null) {
            throw new IllegalArgumentException("Missing 'Problem Number' attribute from data");
        }
        this.nsfiData = data.getAttribute("Detailed Data");
        if (this.nsfiData == null) {
            throw new IllegalArgumentException("Missing 'Detailed Data' attribute from data");
        }
        Trace.trace(TRACE_MASKT, "<-SdPapRequestContent::constructor");
    }

    public byte[] format(byte[] header) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "->SdPapRequestContent::format");
        if (header == null || header.length != 22) {
            throw new IllegalArgumentException("Invalid length of header for service director comfile");
        }
        byte[] comfile = new byte[747];
        comfile[0] = 2;
        comfile[1] = SdPapRequestContent.assignByte(235);
        comfile[2] = SdPapRequestContent.assignByte(129);
        comfile[4] = 0;
        comfile[5] = 2;
        comfile[6] = 0;
        int i = 0;
        while (i < 22) {
            comfile[i + 7] = header[i];
            ++i;
        }
        try {
            comfile[29] = 3;
            RsfMachineInfo machInfo = this.data.getReportingMachineInfo();
            byte[] machType = machInfo.getMachineType().substring(0, 4).getBytes(EBCDIC);
            int i2 = 0;
            while (i2 < 4) {
                comfile[i2 + 30] = machType[i2];
                comfile[i2 + 45] = machType[i2];
                ++i2;
            }
            byte[] machModel = machInfo.getMachineModel().substring(0, 3).getBytes(EBCDIC);
            int i3 = 0;
            while (i3 < 3) {
                comfile[i3 + 35] = machModel[i3];
                comfile[i3 + 50] = machModel[i3];
                ++i3;
            }
            String machSer = machInfo.getMachineSerial();
            String serial = machSer.substring(3, 5) + machSer.substring(7, 12);
            byte[] machSerial = serial.getBytes(EBCDIC);
            int i4 = 0;
            while (i4 < 7) {
                comfile[i4 + 38] = machSerial[i4];
                comfile[i4 + 53] = machSerial[i4];
                ++i4;
            }
            comfile[66] = 1;
            comfile[67] = 8;
            comfile[68] = 0;
            comfile[69] = 64;
            comfile[73] = SdPapRequestContent.assignByte(128);
            byte[] blank = new String(" ").getBytes(EBCDIC);
            int i5 = 102;
            while (i5 < 129) {
                comfile[i5] = blank[0];
                ++i5;
            }
            byte[] custcon = this.customerContact.getBytes(EBCDIC);
            int lCustcon = Math.min(custcon.length, 36);
            byte[] custphon = this.customerNumber.getBytes(EBCDIC);
            int lCustphon = Math.min(custphon.length, 30);
            byte[] servphon = this.baseCustomerNumber.getBytes(EBCDIC);
            int lServphon = Math.min(servphon.length, 30);
            int i6 = 0;
            while (i6 < lCustcon) {
                comfile[i6 + 207] = custcon[i6];
                ++i6;
            }
            int i7 = lCustcon;
            while (i7 < 36) {
                comfile[i7 + 207] = blank[0];
                ++i7;
            }
            int i8 = 0;
            while (i8 < lCustphon) {
                comfile[i8 + 243] = custphon[i8];
                ++i8;
            }
            int i9 = lCustphon;
            while (i9 < 30) {
                comfile[i9 + 243] = blank[0];
                ++i9;
            }
            int i10 = 0;
            while (i10 < lServphon) {
                comfile[i10 + 273] = servphon[i10];
                ++i10;
            }
            int i11 = lServphon;
            while (i11 < 30) {
                comfile[i11 + 273] = blank[0];
                ++i11;
            }
            byte[] copyWrite = COPYWRIT.getBytes(EBCDIC);
            int i12 = 0;
            while (i12 < copyWrite.length) {
                comfile[i12 + 333] = copyWrite[i12];
                ++i12;
            }
            byte[] prob_num = this.cpn.getBytes(EBCDIC);
            int lProb_num = Math.min(prob_num.length, 4);
            int i13 = 0;
            while (i13 < lProb_num) {
                comfile[i13 + 389] = copyWrite[i13];
                ++i13;
            }
            int i14 = 394;
            while (i14 < 458) {
                comfile[i14] = blank[0];
                ++i14;
            }
            byte[] ectab = this.nsfiData.getBytes(EBCDIC);
            int lEctab = Math.min(ectab.length, 288);
            int i15 = 0;
            while (i15 < lEctab) {
                comfile[i15 + 459] = ectab[i15];
                ++i15;
            }
            int i16 = lEctab;
            while (i16 < 288) {
                comfile[i16 + 459] = blank[0];
                ++i16;
            }
            comfile[501] = 3;
            comfile[597] = 3;
            comfile[693] = 3;
        }
        catch (UnsupportedEncodingException e) {
            Trace.trace(TRACE_MASKF, "SdPapRequestContent.format: Unsupported Encoding Exception");
            new FrameworkLog(logInfo, 12546, e).log(infoLog);
        }
        Trace.trace(TRACE_MASKD, "Service Director Pap comfile:");
        Trace.trace(TRACE_MASKD, this.dumpComfile(comfile));
        return comfile;
    }

    public String dumpComfile(byte[] data) {
        if (data.length < 747) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < 715) {
            int j = 0;
            while (j < 8) {
                buffer.append(RsfHexadecimal.buildHexadecimalString(data, i + j * 4, 4) + " ");
                ++j;
            }
            buffer.append('\n');
            i += 32;
        }
        buffer.append(RsfHexadecimal.buildHexadecimalString(data, 735, 4) + " ");
        buffer.append(RsfHexadecimal.buildHexadecimalString(data, 739, 4) + " ");
        buffer.append(RsfHexadecimal.buildHexadecimalString(data, 743, 3) + "\n");
        return buffer.toString();
    }

    public static byte assignByte(int i) {
        if (i <= 127) {
            return (byte)i;
        }
        return (byte)(i | neg);
    }
}

